clear();
clc();
close all;                              											%Plots schließen

%KONFIGURATION---------------------------------------------------------------------
aLGS(1,:)=[ 2,-1, 4, 1,-1,"X1","=",  7];
aLGS(2,:)=[-1, 3,-2,-1, 2,"X2","=",  1];
aLGS(3,:)=[ 5, 1, 3,-4, 1,"X3","=", 33];
aLGS(4,:)=[ 3,-2,-2,-2, 3,"X4","=", 24];
aLGS(5,:)=[-4,-1,-5, 3,-4,"X5","=",-49];
sKommastellenDouble = '%.8f';          												%Nachkommastellen, die in einer Berechnung mitgeschleift werden sollen

%PRUEFUNG--------------------------------------------------------------------------
iANZAHL_GLEICHUNGEN = size(aLGS,1);                                                 %Gibt die Anzahl an Zeilen zurück (Parameter 1)
iANZAHL_WERTE = size(aLGS,2)-3;                                                     %Gibt die Anzahl der Spalten zurück (Parameter 2) abzüglich 3 ("X";"=";Ergebnis)
if(iANZAHL_GLEICHUNGEN<iANZAHL_WERTE)
   fprintf("Scotty, wir haben ein Problem!\n"); 
   fprintf("Es gibt weniger Gleichungen als Unbekannte!\n"); 
   return;                                                                          %Hoffe das beendet das Skript vorzeitig
end
fprintf("Lineares Gleichungssystem b=A*x \n");
disp(aLGS);

%DREIECKSZERLEGUNG-----------------------------------------------------------------
for(i=1:1:iANZAHL_GLEICHUNGEN-1)
    %PIVOTISIERUNG-----------------------------------------------------------------
    [Maximalwert,Zeilenindex]=max(abs(str2double(aLGS(i:end,i))));                  %Durchsucht die i-te Spalte startend von Zeile i des Gleichungssystems nach dem maximalen Betrag und gibt (im Falle mehrerer Maximalwerte) den ersten Zeilenindex zurck
    Zeilenindex=Zeilenindex+i-1;                                                    %Korrektur, weil der Vektor in der max-Abfrage um die i-te Zeile schleifenweise sukzessive verkleinert wird
    Zwischenspeicher = aLGS(Zeilenindex,:);
    aLGS(Zeilenindex,:)=aLGS(i,:);
    aLGS(i,:)=Zwischenspeicher;

    %VERBLEIBENDE_GLEICHUNGEN_ABARBEITEN-------------------------------------------
    for(j=i+1:1:iANZAHL_GLEICHUNGEN)                                                %Startgleichung = i+1, weil die erste Gleichung in der man rechnet die Gleichung 2 ist; Ende = Anzahl Gleichungen Gleichungssystem
        Quotient = str2double(aLGS(j,i))/str2double(aLGS(i,i));                     %Nimmt die i-te Spalte, weil mit Durchlaufen oberster for-Schleife die linken Spalten sukzessive 0 werden
        
        %ELEMENTE_DER_GLEICHUNGEN_ABARBEITEN---------------------------------------
        for(k=i:1:(iANZAHL_WERTE))
            aLGS(j,k) = num2str(str2double(aLGS(j,k)) - Quotient*str2double(aLGS(i,k)),sKommastellenDouble);
        end
        aLGS(j,size(aLGS,2)) = num2str(str2double(aLGS(j,size(aLGS,2))) - Quotient*str2double(aLGS(i,size(aLGS,2))),sKommastellenDouble);
    end
end
fprintf("zerlegtes Lineares Gleichungssystem = \n");
disp(aLGS);

%RÜCKWÜRTSAUFLÖSUNG----------------------------------------------------------------------------
for(i=iANZAHL_GLEICHUNGEN:-1:1)
    Zwischenspeicher=0;
    for(j=i+1:1:iANZAHL_WERTE)
        Zwischenspeicher=Zwischenspeicher+(str2double(aLGS(i,j))*str2double(aX(j,size(aX,2))));
    end
    aX(i,1)=strcat("X",num2str(i));
    aX(i,2)="=";
    aX(i,3)=num2str((str2double(aLGS(i,size(aLGS,2)))-Zwischenspeicher)/str2double(aLGS(i,i)),sKommastellenDouble);
end
fprintf("X-Lösungsvektor = \n");
disp(aX);

%PROGRAMMENDE----------------------------------------------------------------------------------
clearvars -except aLGS aX                                                           %Workspace aufräumen